#ifndef _OMATLAB_H_
#define _OMATLAB_H_

#ifdef _OMATLAB_IMPLEMENTATION_ //implement in VC
#define OMATLAB_API	__declspec(dllexport)
#else	//use in OC
#define	OMATLAB_API
#pragma dll(oMatlab)
#endif
#endif	//_OMATLAB_H_
//omatlab initialization, need to call this before call any other API within this module
OMATLAB_API	bool	omatlab_init();
//omatlab clean up, when user do not need to call any API, should call this to clean up and free resources
OMATLAB_API	bool	omatlab_free();
//make sure nRows1 == nRows2 while nCols1 == nCols2 !!!
/**
	Parameters:
	mat1 := [Input] the buffer that contains data points(column-wise) of the first matrix.
	nRows1 := [Input] the number of rows of the first matrix.
	nCols1 := [Input] the number of columns of the first matrix.
	mat2 := [Input] the buffer that contains data points(column-wise) of the second matrix.
	nRows2 := [Input] the number of rows of the second matrix, should be same as nRows1.
	nCols2 := [Input] the number of columns of the second matrix, should be same as nCols1.
	matOut := [Output] the buffer to receive the result data points(column-wise).
*/
OMATLAB_API	bool	omatlab_add_matrix(double* mat1, int nRows1, int nCols1, double* mat2, int nRows2, int nCols2, double* matOut);
//do gauss fitting
/**
	Parameters:
		xIn := [Input] contains X data points of the curve.
		yIn := [Input] contains Y data points of the curve.
		nSize := [Input] the size of the input curve.
		vParams := [Input/Output] the initial parameters of gauss when input, and the fitted parameters when output.
		xOut := [Input] the X data points to calculate corresponding Y data points after fitting the result parameters.
		yOut := [Output] the fitted Y data points base on the result parameters and xOut.
	Return:
		Returns true on success, or else return false.
*/
OMATLAB_API	bool	omatlab_gauss_fit(double* xIn, double* yIn, int nSize, double* vParams, double* xOut, double* yOut, int nOutSize);